import { Card, CardContent } from "@/components/ui/card"
import { Rocket } from "lucide-react"

export function WelcomeStep() {
  return (
    <div className="space-y-6 py-4">
      <div className="flex justify-center">
        <div className="rounded-full bg-primary/10 p-6">
          <Rocket className="h-12 w-12 text-primary" />
        </div>
      </div>

      <div className="space-y-2 text-center">
        <h2 className="text-2xl font-bold">Welcome to ProductName</h2>
        <p className="text-muted-foreground">
          Let's get you set up in just a few quick steps. We'll collect some information to personalize your experience.
        </p>
      </div>

      <div className="grid gap-4">
        <Card>
          <CardContent className="p-4 flex items-center gap-4">
            <div className="h-8 w-8 rounded-full bg-primary/10 flex items-center justify-center">
              <span className="font-medium text-primary">1</span>
            </div>
            <div>
              <h3 className="font-medium">Personal Information</h3>
              <p className="text-sm text-muted-foreground">Tell us a bit about yourself</p>
            </div>
          </CardContent>
        </Card>

        <Card>
          <CardContent className="p-4 flex items-center gap-4">
            <div className="h-8 w-8 rounded-full bg-primary/10 flex items-center justify-center">
              <span className="font-medium text-primary">2</span>
            </div>
            <div>
              <h3 className="font-medium">Company Details</h3>
              <p className="text-sm text-muted-foreground">Information about your organization</p>
            </div>
          </CardContent>
        </Card>

        <Card>
          <CardContent className="p-4 flex items-center gap-4">
            <div className="h-8 w-8 rounded-full bg-primary/10 flex items-center justify-center">
              <span className="font-medium text-primary">3</span>
            </div>
            <div>
              <h3 className="font-medium">Your Role & Goals</h3>
              <p className="text-sm text-muted-foreground">Help us understand how we can help you</p>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  )
}
