import { CheckCircle } from "lucide-react"

interface SuccessStepProps {
  userData: {
    firstName: string
    lastName: string
    email: string
    companyName: string
    companySize: string
    industry: string
    role: string
    useCase: string
    [key: string]: string
  }
}

export function SuccessStep({ userData }: SuccessStepProps) {
  const getUseCaseLabel = (useCase: string) => {
    const useCases: Record<string, string> = {
      productivity: "Improving team productivity",
      collaboration: "Enhancing collaboration",
      automation: "Automating workflows",
      analytics: "Data analysis and reporting",
      customer: "Customer relationship management",
      other: "Other",
    }
    return useCases[useCase] || useCase
  }

  const getRoleLabel = (role: string) => {
    const roles: Record<string, string> = {
      executive: "Executive/C-Level",
      manager: "Manager/Team Lead",
      individual: "Individual Contributor",
      other: "Other",
    }
    return roles[role] || role
  }

  return (
    <div className="space-y-6 py-4">
      <div className="flex justify-center">
        <div className="rounded-full bg-green-100 p-6">
          <CheckCircle className="h-12 w-12 text-green-600" />
        </div>
      </div>

      <div className="space-y-2 text-center">
        <h2 className="text-2xl font-bold">You're all set, {userData.firstName}!</h2>
        <p className="text-muted-foreground">
          Your account has been created and we've personalized your experience based on your information.
        </p>
      </div>

      <div className="space-y-4 rounded-lg border p-4">
        <div className="space-y-1">
          <p className="text-sm font-medium text-muted-foreground">Personal Information</p>
          <p className="font-medium">
            {userData.firstName} {userData.lastName}
          </p>
          <p>{userData.email}</p>
        </div>

        <div className="space-y-1 pt-2 border-t">
          <p className="text-sm font-medium text-muted-foreground">Company Information</p>
          <p className="font-medium">{userData.companyName}</p>
          <p>
            {userData.companySize} employees • {userData.industry}
          </p>
        </div>

        <div className="space-y-1 pt-2 border-t">
          <p className="text-sm font-medium text-muted-foreground">Role & Use Case</p>
          <p>{getRoleLabel(userData.role)}</p>
          <p>{getUseCaseLabel(userData.useCase)}</p>
        </div>
      </div>

      <div className="text-center">
        <p className="text-muted-foreground">Your dashboard is being prepared. You'll be redirected in a moment...</p>
      </div>
    </div>
  )
}
