"use client"

import { useState } from "react"
import { OnboardingWizard } from "@/components/onboarding/onboarding-wizard"
import { WelcomeStep } from "@/components/onboarding/steps/welcome-step"
import { PersonalInfoStep } from "@/components/onboarding/steps/personal-info-step"
import { CompanyInfoStep } from "@/components/onboarding/steps/company-info-step"
import { RoleSelectionStep } from "@/components/onboarding/steps/role-selection-step"
import { SuccessStep } from "@/components/onboarding/steps/success-step"

export default function OnboardingPage() {
  const [userData, setUserData] = useState({
    firstName: "",
    lastName: "",
    email: "",
    companyName: "",
    companySize: "",
    industry: "",
    role: "",
    useCase: "",
  })

  const updateUserData = (data: Partial<typeof userData>) => {
    setUserData((prev) => ({ ...prev, ...data }))
  }

  const steps = [
    {
      id: "welcome",
      title: "Welcome",
      component: <WelcomeStep />,
    },
    {
      id: "personal",
      title: "Personal Info",
      component: <PersonalInfoStep userData={userData} updateUserData={updateUserData} />,
    },
    {
      id: "company",
      title: "Company Info",
      component: <CompanyInfoStep userData={userData} updateUserData={updateUserData} />,
    },
    {
      id: "role",
      title: "Your Role",
      component: <RoleSelectionStep userData={userData} updateUserData={updateUserData} />,
    },
    {
      id: "success",
      title: "All Set!",
      component: <SuccessStep userData={userData} />,
    },
  ]

  const handleComplete = async () => {
    // Here you would typically send the collected data to your backend
    console.log("Onboarding completed with data:", userData)
    // You could redirect the user to their dashboard or show a success message
  }

  return (
    <div className="min-h-screen bg-gray-50 py-12 px-4 sm:px-6 lg:px-8">
      <div className="max-w-3xl mx-auto">
        <OnboardingWizard steps={steps} onComplete={handleComplete} />
      </div>
    </div>
  )
}
